//+------------------------------------------------------------------+
//|                                                  e-Monday_LS.mq4 |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|    16.12.2005         |
//|        LONG  SHORT.         |
//+------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"
#define   MAGIC     20051216

//-------    --------------------------------
extern string _Parameters_Trade = "-----  ";
extern int    lStopLoss     = 45;    //   
extern int    lTakeProfit   = 180;   //   
extern int    lDayForClose  = 4;     //    
extern int    lHourClosePos = 10;    //   
extern int    sStopLoss     = 35;    //   
extern int    sTakeProfit   = 250;   //   
extern int    sDayForClose  = 2;     //    
extern int    sHourClosePos = 13;    //   
extern int    HourOpenPos   = 11;    //   
extern int    RangeFriday   = 0;     //   (Open-Close)
extern double Lots          = 0.1;   //   
extern int    Slippage      = 3;     //  

//----    -------------------------------
bool   bLastBuy;
int    NumberOfTry   = 9;
bool   UseSound      = True;
string NameFileSound = "expert.wav";
color  clOpenBuy     = LightBlue;
color  clOpenSell    = LightCoral;
color  clModifyBuy   = Aqua;
color  clModifySell  = Tomato;
color  clCloseBuy    = Blue;
color  clCloseSell   = Red;

//-------    ---------------------------------
#include <a-SimpleTrailing.mqh>
#include <stdlib.mqh>

void deinit() { Comment(""); }

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start() {
  if (DayOfWeek()==1 && Hour()==HourOpenPos && Minute()<=10) OpenPosition();
  if (bLastBuy) {
    if (DayOfWeek()==lDayForClose && Hour()>=lHourClosePos) CloseAllPositions();
    TrailingStop=80;
  } else {
    if (DayOfWeek()==sDayForClose && Hour()>=sHourClosePos) CloseAllPositions();
    TrailingStop=100;
  }
  if (UseTrailing) TrailingPositions();
}

//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void OpenPosition() {
  double ldStop=0, ldTake=0;
  int    bs=GetSignal();

  if (!ExistPosition()) {
    if (bs>0) {
      if (lStopLoss!=0) ldStop=Ask-lStopLoss*Point;
      if (lTakeProfit!=0) ldTake=Ask+lTakeProfit*Point;
      SetOrder(OP_BUY, Ask, ldStop, ldTake);
      bLastBuy=True;
    }
    if (bs<0) {
      if (sStopLoss!=0) ldStop=Bid+sStopLoss*Point;
      if (sTakeProfit!=0) ldTake=Bid-sTakeProfit*Point;
      SetOrder(OP_SELL, Bid, ldStop, ldTake);
      bLastBuy=False;
    }
  }
}

//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
int GetSignal() {
  double op1=iOpen (NULL, PERIOD_D1, 1);
  double cl1=iClose(NULL, PERIOD_D1, 1);
  int    bs=0;

  if (MathAbs(op1-cl1)>RangeFriday*Point) {
    if (op1>Ask) bs=1;
    if (op1<Bid) bs=-1;
  }
  return(bs);
}

//+------------------------------------------------------------------+
//|                        |
//+------------------------------------------------------------------+
bool ExistPosition() {
  bool Exist=False;
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC) {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          Exist=True; break;
        }
      }
    }
  }
  return(Exist);
}

//+------------------------------------------------------------------+
//|                                                   |
//| :                                                       |
//|   op     -                                               |
//|   pp     -                                                   |
//|   ldStop -                                            |
//|   ldTake -                                            |
//+------------------------------------------------------------------+
void SetOrder(int op, double pp, double ldStop, double ldTake) {
  color clOpen;

  if (op==OP_BUY) clOpen=clOpenBuy; else clOpen=clOpenSell;
  OrderSend(Symbol(),op,Lots,pp,Slippage,ldStop,ldTake,"",MAGIC,0,clOpen);
}

//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void CloseAllPositions() {
  for (int i=OrdersTotal()-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC) {
        if (OrderType()==OP_BUY) {
          OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, clCloseBuy);
        }
        if (OrderType()==OP_SELL) {
          OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, clCloseSell);
        }
      }
    }
  }
}
//+------------------------------------------------------------------+

